package rahmawati.paerah.jaluralternatif.data_jalur;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.Collections;
import java.util.List;

import rahmawati.paerah.jaluralternatif.R;


public class Adapter_jalur extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private Context context;
    private LayoutInflater inflater;
    List<Data_jalur> data= Collections.emptyList();
    Data_jalur current;
    int currentPos=0;

    // create constructor to innitilize context and data sent from MainActivity
    public Adapter_jalur(Context context, List<Data_jalur> data){
        this.context=context;
        inflater= LayoutInflater.from(context);
        this.data=data;
    }

    // Inflate the layout when viewholder created
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view=inflater.inflate(R.layout.container_jalur, parent,false);
        MyHolder holder=new MyHolder(view);

        return holder;
    }

    // Bind data
    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {

        // Get current position of item in recyclerview to bind data and assign values from list
        MyHolder myHolder= (MyHolder) holder;
        Data_jalur current=data.get(position);
        myHolder.textName.setText("Nama Jalan: "+ current.nama);
        myHolder.textalamat.setText(current.jammacet);
        myHolder.textlati.setText( current.lat);
        myHolder.textlongi.setText( current.longi);
        myHolder.textid.setText("");
        myHolder.p.setText(current.pim);
        myHolder.textName
                .setTextColor(ContextCompat.getColor(context, R.color.colorAccent));


        // load image into imageview using glide
       // Glide.with(context).load("http://192.168.1.7/test/images/" + current.fishImage)
       //         .placeholder(R.drawable.ic_img_error)
         //       .error(R.drawable.ic_img_error)
          //      .into(myHolder.ivFish);

    }

    // return total item from List
    @Override
    public int getItemCount() {
        return data.size();
    }


    class MyHolder extends RecyclerView.ViewHolder{

        TextView textName;
        ImageView ivFish;
        TextView textalamat;
        TextView textlati;
        TextView textid;
        TextView textlongi;
        TextView p;
        // create constructor to get widget reference
        public MyHolder(View itemView) {
            super(itemView);
            textName= (TextView) itemView.findViewById(R.id.nama);
            ivFish= (ImageView) itemView.findViewById(R.id.ivFish);
            textalamat = (TextView) itemView.findViewById(R.id.alamat);
            textlati = (TextView) itemView.findViewById(R.id.lati);
            textlongi = (TextView) itemView.findViewById(R.id.longi);
            textid = (TextView) itemView.findViewById(R.id.textPrice);
            p = (TextView) itemView.findViewById(R.id.pimpinan);
        }

    }

}
